%% EJEMPLO 10: PASEO ALEATORIO (RANDOM WALK)
clear; clf; clc;

N=1e3; % Longitud del vector aleatorio a generar
%% Algoritmo
x=zeros(1,N); x(1)=0;
y=zeros(1,N); y(1)=0;
n_exp=floor(sqrt(N)); % Nmero de veces que se repite el experimento
R2=zeros(n_exp,N); R2(n_exp,1)=0;
% Algoritmo
for j=1:n_exp
    for i=2:N
        Dx=-1+(1+1)*rand(1); % Generacin de delta_x entre [-1,1]
        Dy=-1+(1+1)*rand(1); % Generacin de delta_y entre [-1,1]
        L=sqrt(Dx^2+Dy^2);
        x(i)=x(i-1)+Dx/L;
        y(i)=y(i-1)+Dy/L;
        R2(j,i)=(x(i)^2+y(i)^2);
    end
end
R2_mean=mean(R2);
% Ilustracin grfica
subplot(1,2,1); plot(x,y); hold on;
subplot(1,2,1); plot(x(1),y(1),'k*'); subplot(1,2,1); plot(x(N),y(N),'r*') % Sealamos el 1er y ltimo punto
title('2D RANDOM WALK - PASEO ALEATORIO');
xlabel('x'); ylabel('y');
legend('trayectoria','comienzo','fin','Location','SouthEast');
subplot(1,2,2); plot(sqrt(1:N),sqrt(R2_mean)); hold on;
r_rms=1;
subplot(1,2,2); plot(sqrt(1:N),sqrt(1:N)*r_rms,'r-.');
title('DISTANCIA RADIAL RECORRIDA');
xlabel('sqrt(N)'); ylabel('R');
legend('simulacin','ecuacin terica','Location','SouthEast');